/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.SchemNamesToLay;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class NCCTest
extends AbstractTest {
    public NCCTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new NCCTest("Q0"));
        list.add(new NCCTest("Q1"));
        list.add(new NCCTest("Q2"));
        list.add(new NCCTest("Q3"));
        list.add(new NCCTest("Q4"));
        list.add(new NCCTest("Q5"));
        list.add(new NCCTest("M0"));
        list.add(new NCCTest("M1"));
        list.add(new NCCTest("M2"));
        list.add(new NCCTest("M3"));
        list.add(new NCCTest("M4"));
        list.add(new NCCTest("M5"));
        list.add(new NCCTest("M6"));
        list.add(new NCCTest("M7"));
        list.add(new NCCTest("M8"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/NCC/output/";
    }

    public boolean Q0() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ0Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ0Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/qThreeTop.jelib", "qThreeTop");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 39, 0, 0, false, 139, 0, 0, 0, 0, new String[]{"rowColScan:drivePass{sch} with: rowColScan:drivePass{lay}", "rowColScan:scan2{sch} with: rowColScan:scan2{lay}", "rowColScan:scanBoost5{sch} with: rowColScan:scanBoost5{lay}", "group:fullGroupCap{sch} with: group:fullGroupCap{lay}", "rowColScan:scan6{sch} with: rowColScan:scan6{lay}", "jtag:IRdecode{sch} with: jtag:IRdecode{lay}", "jtag:tsinv{sch} with: jtag:tsinv{lay}", "jtag:jtagScanControl{sch} with: jtag:jtagScanControl{lay}", "jtag:tapCtlJKL{sch} with: jtag:tapCtlJKL{lay}", "jtag:jtagCentral{sch} with: jtag:jtagCentral{lay}", "qThree_pads_180nm:padGnd{sch} with: qThree_pads_180nm:padGnd{lay}", "padParts:bufStrength48{sch} with: padParts:bufStrength48{lay}", "padParts:padpart_buf90{sch} with: padParts:padpart_buf90{lay}", "qThree_pads_180nm:padInStrong{sch} with: qThree_pads_180nm:padInStrong{lay}", "qThree_pads_180nm:padOut{sch} with: qThree_pads_180nm:padOut{lay}", "qThree_pads_180nm:padRawESD{sch} with: qThree_pads_180nm:padRawESD{lay}", "qThree_pads_180nm:padVdd{sch} with: qThree_pads_180nm:padVdd{lay}", "qThreeTop:rectGroup{sch} with: qThreeTop:rectGroup{lay}", "qThreeTop:qThreeTop{sch} with: qThreeTop:qThreeTop{lay}"});
    }

    public boolean Q1() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ1Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ1Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/qThreeTop.jelib", "rectifier");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 3, 0, 0, false, 5, 0, 0, 0, 0, new String[0]);
    }

    public boolean Q2() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ2Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ2Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/rowColScan.jelib", "colScanCx1");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 2, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean Q3() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ3Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ3Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/rowColScan.jelib", "driveRow");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 1, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean Q4() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ4Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ4Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/scanFans.jelib", "scanAmp8w432");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 2, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean Q5() {
        this.createMessageOutput();
        return NCCTest.NCCTestQ5Run(this.getRegressionPath());
    }

    public static boolean NCCTestQ5Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/qThree/jtag.jelib", "jtagIRControl");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 5, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M0() {
        this.createMessageOutput();
        return NCCTest.NCCTestM0Run(this.getRegressionPath());
    }

    public static boolean NCCTestM0Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/MIPS.jelib", "chip");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 135, 0, 600, false, 89, 6, 3, 0, 0, new String[]{"DatapathDone:mdunit{sch} with: DatapathDone:mdunit{lay}", "DatapathDone:nand3_1x{sch} with: DatapathDone:nand3_1x{lay}", "DatapathDone:or3_1x{sch} with: DatapathDone:or3_1x{lay}", "memsys_final:memsys{sch} with: memsys_final:memsys{lay}", "MIPS:mips{sch} with: MIPS:mips{lay}", "muddlib07:a22o2_1x{sch} with: muddlib07:a22o2_1x{lay}", "muddlib07:nand3_1_5x{sch} with: muddlib07:nand3_1_5x{lay}", "muddlib07:or3_1x{sch} with: muddlib07:or3_1x{lay}"});
    }

    public boolean M1() {
        this.createMessageOutput();
        return NCCTest.NCCTestM1Run(this.getRegressionPath());
    }

    public static boolean NCCTestM1Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/DatapathDone.jelib", "Shifter_dp");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 7, 0, 0, false, 12, 0, 5, 0, 0, new String[0]);
    }

    public boolean M2() {
        this.createMessageOutput();
        return NCCTest.NCCTestM2Run(this.getRegressionPath());
    }

    public static boolean NCCTestM2Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/DatapathDone.jelib", "controlPLA");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 1, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M3() {
        this.createMessageOutput();
        return NCCTest.NCCTestM3Run(this.getRegressionPath());
    }

    public static boolean NCCTestM3Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/DatapathDone.jelib", "regramarray_dp");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 3, 0, 0, false, 2, 0, 0, 0, 0, new String[0]);
    }

    public boolean M4() {
        this.createMessageOutput();
        return NCCTest.NCCTestM4Run(this.getRegressionPath());
    }

    public static boolean NCCTestM4Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/memsys_final.jelib", "cacheramarray");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 3, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M5() {
        this.createMessageOutput();
        return NCCTest.NCCTestM5Run(this.getRegressionPath());
    }

    public static boolean NCCTestM5Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/memsys_final.jelib", "datapath");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 8, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M6() {
        this.createMessageOutput();
        return NCCTest.NCCTestM6Run(this.getRegressionPath());
    }

    public static boolean NCCTestM6Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/new_controller.jelib", "alushpla");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 1, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M7() {
        this.createMessageOutput();
        return NCCTest.NCCTestM7Run(this.getRegressionPath());
    }

    public static boolean NCCTestM7Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/new_controller.jelib", "maindec");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 3, 0, 0, true, 0, 0, 0, 0, 0, new String[0]);
    }

    public boolean M8() {
        this.createMessageOutput();
        return NCCTest.NCCTestM8Run(this.getRegressionPath());
    }

    public static boolean NCCTestM8Run(String regressionDirPath) {
        RootCells rootCells = NCCTest.getRootCells(regressionDirPath, "data/muddChip/new_controller.jelib", "registers");
        NccResults results = NCCTest.compare(rootCells.sch, null, rootCells.lay, null, NCCTest.hierOptions());
        return NCCTest.checkResults(results, 4, 0, 0, false, 6, 1, 0, 0, 0, new String[0]);
    }

    private static NccOptions hierOptions() {
        NccOptions options = new NccOptions();
        options.operation = 0;
        options.haltAfterFirstMismatch = false;
        options.oneNamePerPort = false;
        return options;
    }

    private static NccResults compare(Cell c1, VarContext v1, Cell c2, VarContext v2, NccOptions opt) {
        try {
            return Ncc.compare(c1, v1, c2, v2, opt);
        }
        catch (Throwable t) {
            System.out.println("NCC throws Throwable: " + t);
            t.printStackTrace();
            return null;
        }
    }

    private static String getRegressionDirPath(String regressionDirPath) {
        if (regressionDirPath != null) {
            return regressionDirPath;
        }
        return "../..";
    }

    private static String getFailedCellPair(NccResult result) {
        String[] cellNms = result.getRootCellNames();
        return cellNms[0] + " with: " + cellNms[1];
    }

    private static boolean checkResults(NccResults results, int expectedTopologyPassed, int expectSzErrs, int expectedRegErrs, boolean testRenaming, int numArcRenames, int numNodeRenames, int numArcManRenames, int numNodeManRenames, int numNameConflicts, String[] failedCellPairs) {
        HashSet<String> setFailedPairs = new HashSet<String>();
        ArrayList<String> unexpectedFailed = new ArrayList<String>();
        for (int i = 0; i < failedCellPairs.length; ++i) {
            setFailedPairs.add(failedCellPairs[i]);
        }
        int numPassed = 0;
        int numSzErrs = 0;
        int eqErrs = 0;
        boolean ok = true;
        for (NccResult result : results) {
            if (result.exportMatch() && result.topologyMatch()) {
                ++numPassed;
            } else {
                String failedCellPair = NCCTest.getFailedCellPair(result);
                if (!setFailedPairs.contains(failedCellPair)) {
                    unexpectedFailed.add(failedCellPair);
                }
            }
            numSzErrs += result.getNccGuiInfo().getSizeMismatches().size();
            Cell cell1 = result.getRootCells()[0];
            Cell cell2 = result.getRootCells()[1];
            eqErrs += result.getEquivalence().regressionTest(cell1, cell2);
        }
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        SchemNamesToLay.RenameResult rr = SchemNamesToLay.copyNames(results, ep);
        System.out.println("========================== Regression Results =============================");
        for (String failedCellPair : unexpectedFailed) {
            System.out.println("Unexpected comparison failure: " + failedCellPair);
            ok = false;
        }
        if (expectedTopologyPassed != numPassed) {
            System.out.println("Wrong number of comparisons passed: " + numPassed + " Expected: " + expectedTopologyPassed);
            ok = false;
        }
        if (expectSzErrs != numSzErrs) {
            System.out.println("Wrong number of size errors: " + numSzErrs + " Expected: " + expectSzErrs);
            ok = false;
        }
        if (eqErrs != expectedRegErrs) {
            System.out.println("Wrong number of NCC failures: " + eqErrs + " Expected: " + expectedRegErrs);
            ok = false;
        }
        if (rr.numArcRenames != numArcRenames && testRenaming || rr.numArcRenames > numArcRenames) {
            System.out.println("Wrong number of arc renames: " + rr.numArcRenames + " Expected: " + numArcRenames);
            ok = false;
        }
        if (rr.numNodeRenames != numNodeRenames && testRenaming || rr.numNodeRenames > numNodeRenames) {
            System.out.println("Wrong number of node renames: " + rr.numNodeRenames + " Expected: " + numNodeRenames);
            ok = false;
        }
        if (rr.numArcManRenames != numArcManRenames && testRenaming || rr.numArcManRenames > numArcManRenames) {
            System.out.println("Wrong number of arc manual renames: " + rr.numArcManRenames + " Expected: " + numArcManRenames);
            ok = false;
        }
        if (rr.numNodeManRenames != numNodeManRenames && testRenaming || rr.numNodeManRenames > numNodeManRenames) {
            System.out.println("Wrong number of node manual renames: " + rr.numNodeManRenames + " Expected: " + numNodeManRenames);
            ok = false;
        }
        if (rr.numNameConflicts != numNameConflicts && testRenaming || rr.numNameConflicts > numNameConflicts) {
            System.out.println("Wrong number of renaming conflicts: " + rr.numNameConflicts + " Expected: " + numNameConflicts);
            ok = false;
        }
        return ok;
    }

    private static RootCells getRootCells(String regressionDirPath, String libPath, String cellNm) {
        regressionDirPath = NCCTest.getRegressionDirPath(regressionDirPath);
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        Library rootLib = LayoutLib.openLibForRead(regressionDirPath + "/" + libPath, ep, true);
        Library.repairAllLibraries(ep);
        Cell sch = rootLib.findNodeProto(cellNm + "{sch}");
        Cell lay = rootLib.findNodeProto(cellNm + "{lay}");
        return new RootCells(sch, lay);
    }

    private static class RootCells {
        public final Cell sch;
        public final Cell lay;

        RootCells(Cell s, Cell l) {
            this.sch = s;
            this.lay = l;
        }
    }
}

